/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import noppes.npcs.LogWriter;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.schematics.Schematic;
import noppes.npcs.schematics.SchematicBlockData;
import noppes.npcs.util.Util;

public class BuilderData {
    private int type;
    private int id;
    public int[] region = new int[]{5, 2, 3};
    public int facing = 0;
    public NpcMiscInventory inv = new NpcMiscInventory(10);
    public EntityPlayer player = null;
    public boolean addAir = false;
    public boolean replaceAir = false;
    public boolean isSolid = false;
    public Map<Integer, Integer> chances = new TreeMap<Integer, Integer>();
    private final Random rnd = new Random();
    public Map<Integer, BlockPos> schMap = new TreeMap<Integer, BlockPos>();
    public String schematicName = "";
    public int doPos = 0;
    public Map<Integer, List<SchematicBlockData>> doMap = new TreeMap<Integer, List<SchematicBlockData>>();
    public Map<Integer, List<Entity>> enMap = new TreeMap<Integer, List<Entity>>();
    private long lastWork = 0L;
    private long lastMessage = 0L;

    public BuilderData(int id, int type) {
        this.id = id;
        this.type = type;
    }

    public void add(List<SchematicBlockData> listB, List<Entity> listE) {
        if (this.doPos == 9) {
            this.doMap.remove(0);
            this.enMap.remove(0);
            TreeMap<Integer, List<SchematicBlockData>> db = new TreeMap<Integer, List<SchematicBlockData>>();
            TreeMap<Integer, List<Entity>> de = new TreeMap<Integer, List<Entity>>();
            for (int i = 0; i < 9; ++i) {
                db.put(i, this.doMap.get(i + 1));
                de.put(i, this.enMap.get(i + 1));
            }
            this.doMap = db;
            this.enMap = de;
        } else {
            ++this.doPos;
            if (this.doMap.containsKey(this.doPos + 1)) {
                int i = this.doPos + 1;
                while (this.doMap.containsKey(i)) {
                    this.doMap.remove(i);
                    this.enMap.remove(i);
                    ++i;
                }
            }
        }
        this.doMap.put(this.doPos, listB);
        this.enMap.put(this.doPos, listE);
    }

    public int[] getDirections(EntityPlayer player) {
        int[] d = new int[]{0, 0, 0, 0, 0, 0};
        if (player == null) {
            return d;
        }
        int vertical = player.field_70125_A < -45.0f ? 1 : (player.field_70125_A > 45.0f ? 2 : 0);
        block0 : switch (player.func_174811_aO()) {
            case SOUTH: {
                if (vertical == 1) {
                    switch (this.facing) {
                        case 1: {
                            d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[1] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[3] = this.region[0];
                            d[4] = this.region[1];
                            d[5] = this.region[2];
                            break block0;
                        }
                        case 2: {
                            d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[1] = -1 * this.region[1] + 1;
                            d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[3] = this.region[0];
                            d[4] = this.region[1];
                            d[5] = this.region[2];
                            break block0;
                        }
                    }
                    d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                    d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                    d[3] = this.region[0];
                    d[4] = this.region[1];
                    d[5] = this.region[2];
                    break;
                }
                if (vertical == 2) {
                    switch (this.facing) {
                        case 1: {
                            d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[1] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[3] = this.region[0];
                            d[4] = this.region[1];
                            d[5] = this.region[2];
                            break block0;
                        }
                        case 2: {
                            d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[3] = this.region[0];
                            d[4] = this.region[1];
                            d[5] = this.region[2];
                            break block0;
                        }
                    }
                    d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                    d[1] = -1 * this.region[1] + 1;
                    d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                    d[3] = this.region[0];
                    d[4] = this.region[1];
                    d[5] = this.region[2];
                    break;
                }
                switch (this.facing) {
                    case 1: {
                        d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                        d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                        d[2] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                        d[3] = this.region[0];
                        d[4] = this.region[2];
                        d[5] = this.region[1];
                        break block0;
                    }
                    case 2: {
                        d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                        d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                        d[2] = -1 * this.region[1] + 1;
                        d[3] = this.region[0];
                        d[4] = this.region[2];
                        d[5] = this.region[1];
                        break block0;
                    }
                }
                d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                d[3] = this.region[0];
                d[4] = this.region[2];
                d[5] = this.region[1];
                break;
            }
            case EAST: {
                if (vertical == 1) {
                    switch (this.facing) {
                        case 1: {
                            d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[1] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[3] = this.region[2];
                            d[4] = this.region[1];
                            d[5] = this.region[0];
                            break block0;
                        }
                        case 2: {
                            d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[1] = -1 * this.region[1] + 1;
                            d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[3] = this.region[2];
                            d[4] = this.region[1];
                            d[5] = this.region[0];
                            break block0;
                        }
                    }
                    d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                    d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                    d[3] = this.region[2];
                    d[4] = this.region[1];
                    d[5] = this.region[0];
                    break;
                }
                if (vertical == 2) {
                    switch (this.facing) {
                        case 1: {
                            d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[1] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[3] = this.region[2];
                            d[4] = this.region[1];
                            d[5] = this.region[0];
                            break block0;
                        }
                        case 2: {
                            d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[3] = this.region[2];
                            d[4] = this.region[1];
                            d[5] = this.region[0];
                            break block0;
                        }
                    }
                    d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                    d[1] = -1 * this.region[1] + 1;
                    d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                    d[3] = this.region[2];
                    d[4] = this.region[1];
                    d[5] = this.region[0];
                    break;
                }
                switch (this.facing) {
                    case 1: {
                        d[0] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                        d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                        d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                        d[3] = this.region[1];
                        d[4] = this.region[2];
                        d[5] = this.region[0];
                        break block0;
                    }
                    case 2: {
                        d[0] = -1 * this.region[1] + 1;
                        d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                        d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                        d[3] = this.region[1];
                        d[4] = this.region[2];
                        d[5] = this.region[0];
                        break block0;
                    }
                }
                d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                d[3] = this.region[1];
                d[4] = this.region[2];
                d[5] = this.region[0];
                break;
            }
            case NORTH: {
                if (vertical == 1) {
                    switch (this.facing) {
                        case 1: {
                            d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[1] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[3] = this.region[0];
                            d[4] = this.region[1];
                            d[5] = this.region[2];
                            break block0;
                        }
                        case 2: {
                            d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[1] = -1 * this.region[1] + 1;
                            d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[3] = this.region[0];
                            d[4] = this.region[1];
                            d[5] = this.region[2];
                            break block0;
                        }
                    }
                    d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                    d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                    d[3] = this.region[0];
                    d[4] = this.region[1];
                    d[5] = this.region[2];
                    break;
                }
                if (vertical == 2) {
                    switch (this.facing) {
                        case 1: {
                            d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[1] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[3] = this.region[0];
                            d[4] = this.region[1];
                            d[5] = this.region[2];
                            break block0;
                        }
                        case 2: {
                            d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[3] = this.region[0];
                            d[4] = this.region[1];
                            d[5] = this.region[2];
                            break block0;
                        }
                    }
                    d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                    d[1] = -1 * this.region[1] + 1;
                    d[2] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                    d[3] = this.region[0];
                    d[4] = this.region[1];
                    d[5] = this.region[2];
                    break;
                }
                switch (this.facing) {
                    case 1: {
                        d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                        d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                        d[2] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                        d[3] = this.region[0];
                        d[4] = this.region[2];
                        d[5] = this.region[1];
                        break block0;
                    }
                    case 2: {
                        d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                        d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                        d[3] = this.region[0];
                        d[4] = this.region[2];
                        d[5] = this.region[1];
                        break block0;
                    }
                }
                d[0] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                d[2] = -1 * this.region[1] + 1;
                d[3] = this.region[0];
                d[4] = this.region[2];
                d[5] = this.region[1];
                break;
            }
            case WEST: {
                if (vertical == 1) {
                    switch (this.facing) {
                        case 1: {
                            d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[1] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[3] = this.region[2];
                            d[4] = this.region[1];
                            d[5] = this.region[0];
                            break block0;
                        }
                        case 2: {
                            d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[1] = -1 * this.region[1] + 1;
                            d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[3] = this.region[2];
                            d[4] = this.region[1];
                            d[5] = this.region[0];
                            break block0;
                        }
                    }
                    d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                    d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                    d[3] = this.region[2];
                    d[4] = this.region[1];
                    d[5] = this.region[0];
                    break;
                }
                if (vertical == 2) {
                    switch (this.facing) {
                        case 1: {
                            d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[1] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[3] = this.region[2];
                            d[4] = this.region[1];
                            d[5] = this.region[0];
                            break block0;
                        }
                        case 2: {
                            d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                            d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                            d[3] = this.region[2];
                            d[4] = this.region[1];
                            d[5] = this.region[0];
                            break block0;
                        }
                    }
                    d[0] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                    d[1] = -1 * this.region[1] + 1;
                    d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                    d[3] = this.region[2];
                    d[4] = this.region[1];
                    d[5] = this.region[0];
                    break;
                }
                switch (this.facing) {
                    case 1: {
                        d[0] = -1 * (int)Math.floor((double)this.region[1] / 2.0);
                        d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                        d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                        d[3] = this.region[1];
                        d[4] = this.region[2];
                        d[5] = this.region[0];
                        break block0;
                    }
                    case 2: {
                        d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                        d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                        d[3] = this.region[1];
                        d[4] = this.region[2];
                        d[5] = this.region[0];
                        break block0;
                    }
                }
                d[0] = -1 * this.region[1] + 1;
                d[1] = -1 * (int)Math.floor((double)this.region[2] / 2.0);
                d[2] = -1 * (int)Math.floor((double)this.region[0] / 2.0);
                d[3] = this.region[1];
                d[4] = this.region[2];
                d[5] = this.region[0];
                break;
            }
        }
        return d;
    }

    public NBTTagCompound getNbt() {
        NBTTagCompound nbtData = new NBTTagCompound();
        nbtData.func_74768_a("BuilderType", this.type);
        nbtData.func_74768_a("BuilderFasing", this.facing);
        nbtData.func_74783_a("Region", this.region);
        nbtData.func_74768_a("ID", this.id);
        nbtData.func_74757_a("AddAir", this.addAir);
        nbtData.func_74757_a("ReplaceAir", this.replaceAir);
        nbtData.func_74757_a("IsSolid", this.isSolid);
        NBTTagCompound sch = new NBTTagCompound();
        sch.func_74778_a("FileName", this.schematicName);
        NBTTagList selectMap = new NBTTagList();
        for (BlockPos pos : this.schMap.values()) {
            selectMap.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
        }
        sch.func_74782_a("SelectMap", (NBTBase)selectMap);
        nbtData.func_74782_a("Schematic", (NBTBase)sch);
        NBTTagList chList = new NBTTagList();
        for (int slot : this.chances.keySet()) {
            NBTTagCompound c = new NBTTagCompound();
            c.func_74768_a("Slot", slot);
            c.func_74768_a("Value", this.chances.get(slot).intValue());
            chList.func_74742_a((NBTBase)c);
        }
        nbtData.func_74782_a("Chances", (NBTBase)chList);
        if (this.type < 3) {
            nbtData.func_74782_a("Inventory", (NBTBase)this.inv.save());
        }
        nbtData.func_74778_a("PlayerName", this.player == null ? "null" : this.player.func_70005_c_());
        return nbtData;
    }

    public void read(NBTTagCompound nbtData) {
        if (nbtData.func_150297_b("BuilderType", 3)) {
            this.type = nbtData.func_74762_e("BuilderType");
        }
        if (nbtData.func_150297_b("BuilderFasing", 3)) {
            this.facing = nbtData.func_74762_e("BuilderFasing");
        }
        if (nbtData.func_150297_b("Region", 11)) {
            this.region = nbtData.func_74759_k("Region");
        }
        if (nbtData.func_150297_b("ID", 8)) {
            this.id = nbtData.func_74762_e("ID");
        }
        if (nbtData.func_150297_b("AddAir", 1)) {
            this.addAir = nbtData.func_74767_n("AddAir");
        }
        if (nbtData.func_150297_b("ReplaceAir", 1)) {
            this.replaceAir = nbtData.func_74767_n("ReplaceAir");
        }
        if (nbtData.func_150297_b("IsSolid", 1)) {
            this.isSolid = nbtData.func_74767_n("IsSolid");
        }
        if (nbtData.func_150297_b("Schematic", 10)) {
            NBTTagCompound sch = nbtData.func_74775_l("Schematic");
            if (sch.func_150297_b("FileName", 8)) {
                this.schematicName = sch.func_74779_i("FileName");
            }
            if (sch.func_150297_b("SelectMap", 9)) {
                this.schMap.clear();
                for (int i = 0; i < sch.func_150295_c("SelectMap", 11).func_74745_c(); ++i) {
                    int[] pos = sch.func_150295_c("SelectMap", 11).func_150306_c(i);
                    this.schMap.put(i, new BlockPos(pos[0], pos[1], pos[2]));
                }
            }
        }
        if (nbtData.func_150297_b("Chances", 9)) {
            this.chances.clear();
            for (int i = 0; i < nbtData.func_150295_c("Chances", 10).func_74745_c(); ++i) {
                NBTTagCompound c = nbtData.func_150295_c("Chances", 10).func_150305_b(i);
                this.chances.put(c.func_74762_e("Slot"), c.func_74762_e("Value"));
            }
        }
        if (nbtData.func_150297_b("Inventory", 10)) {
            this.inv.load(nbtData.func_74775_l("Inventory"));
        }
    }

    public void redo() {
        if (this.doPos < 0) {
            this.doPos = 0;
        }
        if (!this.doMap.containsKey(this.doPos + 1)) {
            return;
        }
        ArrayList<SchematicBlockData> listB = new ArrayList<SchematicBlockData>();
        ArrayList<Entity> listE = new ArrayList<Entity>();
        int mx = Integer.MAX_VALUE;
        int my = Integer.MAX_VALUE;
        int mz = Integer.MAX_VALUE;
        int nx = Integer.MIN_VALUE;
        int ny = Integer.MIN_VALUE;
        int nz = Integer.MIN_VALUE;
        World world = null;
        if (this.player != null) {
            world = this.player.field_70170_p;
        }
        for (SchematicBlockData schematicBlockData : this.doMap.get(this.doPos + 1)) {
            if (world == null && schematicBlockData.world != null) {
                world = schematicBlockData.world;
            }
            if (mx > schematicBlockData.pos.func_177958_n()) {
                mx = schematicBlockData.pos.func_177958_n();
            }
            if (nx < schematicBlockData.pos.func_177958_n()) {
                nx = schematicBlockData.pos.func_177958_n();
            }
            if (my > schematicBlockData.pos.func_177956_o()) {
                my = schematicBlockData.pos.func_177956_o();
            }
            if (ny < schematicBlockData.pos.func_177956_o()) {
                ny = schematicBlockData.pos.func_177956_o();
            }
            if (mz > schematicBlockData.pos.func_177952_p()) {
                mz = schematicBlockData.pos.func_177952_p();
            }
            if (nz >= schematicBlockData.pos.func_177952_p()) continue;
            nz = schematicBlockData.pos.func_177952_p();
        }
        if (world != null) {
            List list = new ArrayList();
            try {
                list = world.func_72872_a(Entity.class, new AxisAlignedBB((double)mx - 0.5, (double)my - 0.5, (double)mz - 0.5, (double)nx + 0.5, (double)ny + 1.5, (double)nz + 1.5));
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Entity e : list) {
                if (e instanceof EntityThrowable || e instanceof EntityArrow || e instanceof EntityPlayer) continue;
                listE.add(e);
                e.field_70128_L = true;
            }
        }
        for (SchematicBlockData schematicBlockData : this.doMap.get(this.doPos + 1)) {
            listB.add(new SchematicBlockData(schematicBlockData.world, schematicBlockData.world.func_180495_p(schematicBlockData.pos), schematicBlockData.pos));
            schematicBlockData.set(schematicBlockData.pos);
        }
        if (world != null) {
            for (Entity entity : this.enMap.get(this.doPos + 1)) {
                entity.field_70128_L = false;
                UUID uuid = entity.func_110124_au();
                while (uuid != null) {
                    boolean has = false;
                    for (Entity e : world.field_72996_f) {
                        if (!e.func_110124_au().equals(entity.func_110124_au())) continue;
                        uuid = UUID.randomUUID();
                        entity.func_184221_a(uuid);
                        has = true;
                        break;
                    }
                    if (has) continue;
                    uuid = null;
                }
                world.func_72838_d(entity);
            }
        }
        this.enMap.put(this.doPos + 1, listE);
        this.doMap.put(this.doPos + 1, listB);
        if (this.player != null) {
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation("builder.end.redo", new Object[]{"" + (this.doPos + 2), "" + listB.size()}));
        }
        ++this.doPos;
    }

    public void saveBlocks(EntityPlayerMP player, BlockPos pos, int size) {
        if (this.schematicName.isEmpty()) {
            this.sendMessage("builder.err.file.name", new Object[0]);
            return;
        }
        if (this.schMap.size() != 3) {
            String x = "" + pos.func_177958_n();
            String y = "" + pos.func_177956_o();
            String z = "" + pos.func_177952_p();
            switch (this.schMap.size()) {
                case 1: {
                    this.schMap.put(1, pos);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("builder.set.point.1", new Object[]{x, y, z, this.schematicName}));
                    break;
                }
                case 2: {
                    BlockPos p = this.schMap.get(1);
                    if (p.equals((Object)pos)) {
                        return;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("builder.set.point.2", new Object[]{x, y, z, this.schematicName}));
                    this.schMap.put(2, pos);
                    break;
                }
                default: {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("builder.set.point.0", new Object[]{x, y, z, this.schematicName}));
                    this.schMap.put(0, pos);
                }
            }
            this.lastWork = System.currentTimeMillis();
            Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.BuilderData, this.getNbt()});
            return;
        }
        this.lastWork = System.currentTimeMillis() - (long)size;
        Schematic schema = Schematic.create(player.field_70170_p, player.func_174811_aO(), this.schematicName + ".schematic", this.schMap);
        Server.sendData(player, EnumPacketClient.SAVE_SCHEMATIC, schema.getNBT());
    }

    public void sendMessage(String text, Object ... obj) {
        if (this.lastMessage + 1000L > System.currentTimeMillis() || this.player == null) {
            return;
        }
        this.lastMessage = System.currentTimeMillis();
        this.player.func_145747_a((ITextComponent)new TextComponentTranslation(text, obj));
    }

    public void setBlocks(EntityPlayer player, BlockPos pos) {
        int[] d = this.getDirections(player);
        int cx = 0;
        int cy = 0;
        int cz = 0;
        int size = this.region[0] * this.region[1] * this.region[2];
        ArrayList<SchematicBlockData> listB = new ArrayList<SchematicBlockData>();
        ArrayList<Entity> listE = new ArrayList<Entity>();
        List list = new ArrayList();
        try {
            list = player.field_70170_p.func_72872_a(Entity.class, new AxisAlignedBB((double)d[0] - 0.25, (double)d[1] - 0.25, (double)d[2] - 0.25, (double)d[3] + 0.25, (double)d[4] + 0.25, (double)d[5] + 0.25).func_186670_a(pos));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Entity e : list) {
            if (e instanceof EntityThrowable || e instanceof EntityArrow || e instanceof EntityPlayer) continue;
            listE.add(e);
            e.field_70128_L = true;
        }
        HashMap<Integer, SchematicBlockData> tempBlocks = new HashMap<Integer, SchematicBlockData>();
        SchematicBlockData main = null;
        if (this.type != 0) {
            SchematicBlockData bd;
            int slot;
            Object stack;
            int total = 0;
            int mPos = -1;
            int max = -1;
            HashMap<Integer, Integer> bls = new HashMap<Integer, Integer>();
            if (!this.inv.func_70301_a(0).func_190926_b()) {
                Block.func_149634_a((Item)this.inv.func_70301_a(0).func_77973_b());
                main = new SchematicBlockData(player.field_70170_p, this.inv.func_70301_a(0));
            }
            for (int i = 1; i < 10; ++i) {
                stack = this.inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                Block.func_149634_a((Item)stack.func_77973_b());
                int c = 100;
                if (this.chances.containsKey(i)) {
                    c = this.chances.get(i);
                }
                total += c;
                if (max < c) {
                    max = c;
                    mPos = i;
                }
                bls.put(i, c);
            }
            if (this.addAir) {
                int airV = 100;
                if (!bls.isEmpty()) {
                    airV = total / bls.size();
                }
                total += airV;
                bls.put(mPos + 1, airV);
            }
            if (bls.isEmpty() && (this.type == 1 || this.type == 2)) {
                this.sendMessage("builder.err.not.blocks", new Object[0]);
                return;
            }
            int fix = 0;
            stack = bls.keySet().iterator();
            while (stack.hasNext()) {
                int slot2 = (Integer)stack.next();
                int v = size * (Integer)bls.get(slot2) / total;
                fix += v;
                bls.put(slot2, v);
            }
            if (fix < size && mPos >= 0) {
                bls.put(mPos, (Integer)bls.get(mPos) + size - fix);
            }
            HashMap<Integer, SchematicBlockData> amount = new HashMap<Integer, SchematicBlockData>();
            ArrayList<Integer> slots = new ArrayList<Integer>();
            Iterator v = bls.keySet().iterator();
            while (v.hasNext()) {
                slot = (Integer)v.next();
                bd = slot >= 10 ? new SchematicBlockData(player.field_70170_p, new ItemStack(Blocks.field_150350_a)) : new SchematicBlockData(player.field_70170_p, this.inv.func_70301_a(slot));
                amount.put(slot, bd);
                slots.add(slot);
            }
            for (int i = 0; i < size; ++i) {
                slot = (Integer)slots.get(this.rnd.nextInt(slots.size()));
                bd = (SchematicBlockData)amount.get(slot);
                bls.put(slot, (Integer)bls.get(slot) - 1);
                if ((Integer)bls.get(slot) <= 0) {
                    slots.remove((Object)slot);
                }
                tempBlocks.put(i, bd);
            }
        } else {
            for (int i = 1; i < 10; ++i) {
                ItemStack stack = this.inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                Block.func_149634_a((Item)stack.func_77973_b());
                tempBlocks.put(i, new SchematicBlockData(player.field_70170_p, stack));
            }
        }
        if (tempBlocks.isEmpty() && this.type != 0) {
            this.sendMessage("builder.err.not.blocks", new Object[0]);
            return;
        }
        int sum = 0;
        while (cy < d[4]) {
            while (cz < d[5]) {
                block12: while (cx < d[3]) {
                    SchematicBlockData bd;
                    BlockPos p = new BlockPos(pos.func_177958_n() + d[0] + cx, pos.func_177956_o() + d[1] + cy, pos.func_177952_p() + d[2] + cz);
                    IBlockState state = player.field_70170_p.func_180495_p(p);
                    ++cx;
                    ++sum;
                    if (this.type == 0) {
                        if (state.func_177230_c() == Blocks.field_150350_a) continue;
                        if (!tempBlocks.isEmpty()) {
                            for (SchematicBlockData bd2 : tempBlocks.values()) {
                                if (bd2.state.func_177230_c() != state.func_177230_c()) continue;
                                listB.add(new SchematicBlockData(player.field_70170_p, state, p));
                                player.field_70170_p.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
                                continue block12;
                            }
                            continue;
                        }
                        listB.add(new SchematicBlockData(player.field_70170_p, state, p));
                        player.field_70170_p.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
                        continue;
                    }
                    if (this.type == 1) {
                        bd = (SchematicBlockData)tempBlocks.get(sum - 1);
                        listB.add(new SchematicBlockData(player.field_70170_p, state, p));
                        bd.pos = new BlockPos((Vec3i)p);
                        bd.world = player.field_70170_p;
                        bd.set(bd.pos);
                        continue;
                    }
                    if (this.type != 2 || !this.replaceAir && state.func_177230_c() == Blocks.field_150350_a || main != null && !main.state.func_177230_c().equals(state.func_177230_c())) continue;
                    if (!tempBlocks.isEmpty()) {
                        bd = (SchematicBlockData)tempBlocks.get(this.rnd.nextInt(tempBlocks.size()));
                        listB.add(new SchematicBlockData(player.field_70170_p, state, p));
                        bd.pos = new BlockPos((Vec3i)p);
                        bd.world = player.field_70170_p;
                        try {
                            if (state.func_177230_c() instanceof BlockSlab) {
                                bd.state.func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a));
                            }
                        }
                        catch (Exception e) {
                            LogWriter.error(e);
                        }
                        bd.set(bd.pos);
                        continue;
                    }
                    bd = new SchematicBlockData(player.field_70170_p, ItemStack.field_190927_a);
                    listB.add(new SchematicBlockData(player.field_70170_p, state, p));
                    bd.pos = new BlockPos((Vec3i)p);
                    bd.world = player.field_70170_p;
                    bd.set(bd.pos);
                }
                ++cz;
                cx = 0;
            }
            ++cy;
            cz = 0;
        }
        this.sendMessage("builder.end.work." + !listB.isEmpty(), "" + listB.size());
        if (!listB.isEmpty() || !listE.isEmpty()) {
            this.add(listB, listE);
        }
    }

    public void undo() {
        if (this.doPos > 9) {
            this.doPos = 9;
        }
        if (!this.doMap.containsKey(this.doPos)) {
            return;
        }
        ArrayList<SchematicBlockData> listB = new ArrayList<SchematicBlockData>();
        ArrayList<Entity> listE = new ArrayList<Entity>();
        int mx = Integer.MAX_VALUE;
        int my = Integer.MAX_VALUE;
        int mz = Integer.MAX_VALUE;
        int nx = Integer.MIN_VALUE;
        int ny = Integer.MIN_VALUE;
        int nz = Integer.MIN_VALUE;
        World world = null;
        if (this.player != null) {
            world = this.player.field_70170_p;
        }
        for (SchematicBlockData schematicBlockData : this.doMap.get(this.doPos)) {
            if (world == null && schematicBlockData.world != null) {
                world = schematicBlockData.world;
            }
            if (mx > schematicBlockData.pos.func_177958_n()) {
                mx = schematicBlockData.pos.func_177958_n();
            }
            if (nx < schematicBlockData.pos.func_177958_n()) {
                nx = schematicBlockData.pos.func_177958_n();
            }
            if (my > schematicBlockData.pos.func_177956_o()) {
                my = schematicBlockData.pos.func_177956_o();
            }
            if (ny < schematicBlockData.pos.func_177956_o()) {
                ny = schematicBlockData.pos.func_177956_o();
            }
            if (mz > schematicBlockData.pos.func_177952_p()) {
                mz = schematicBlockData.pos.func_177952_p();
            }
            if (nz >= schematicBlockData.pos.func_177952_p()) continue;
            nz = schematicBlockData.pos.func_177952_p();
        }
        if (world != null) {
            List list = new ArrayList();
            try {
                list = world.func_72872_a(Entity.class, new AxisAlignedBB((double)mx - 0.5, (double)my - 0.5, (double)mz - 0.5, (double)nx + 0.5, (double)ny + 1.5, (double)nz + 1.5));
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Entity e : list) {
                if (e instanceof EntityThrowable || e instanceof EntityArrow || e instanceof EntityPlayer) continue;
                listE.add(e);
                e.field_70128_L = true;
            }
        }
        for (SchematicBlockData schematicBlockData : this.doMap.get(this.doPos)) {
            listB.add(new SchematicBlockData(schematicBlockData.world, schematicBlockData.world.func_180495_p(schematicBlockData.pos), schematicBlockData.pos));
            schematicBlockData.set(schematicBlockData.pos);
        }
        if (world != null) {
            for (Entity entity : this.enMap.get(this.doPos)) {
                entity.field_70128_L = false;
                UUID uuid = entity.func_110124_au();
                while (uuid != null) {
                    boolean has = false;
                    for (Entity e : world.field_72996_f) {
                        if (!e.func_110124_au().equals(entity.func_110124_au())) continue;
                        uuid = UUID.randomUUID();
                        entity.func_184221_a(uuid);
                        has = true;
                        break;
                    }
                    if (has) continue;
                    uuid = null;
                }
                world.func_72838_d(entity);
            }
        }
        this.enMap.put(this.doPos, listE);
        this.doMap.put(this.doPos, listB);
        --this.doPos;
        if (this.player != null) {
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation("builder.end.undo", new Object[]{"" + (this.doPos + 1), "" + listB.size()}));
        }
    }

    public void work(BlockPos pos, EntityPlayerMP player) {
        this.player = player;
        int size = this.region[0] * this.region[1] * this.region[2];
        if (size > 2000) {
            size = 2000;
        }
        if (this.lastWork + (long)(size = (int)(0.875 * (double)size + 250.0)) > System.currentTimeMillis()) {
            this.sendMessage("builder.wait", Util.instance.ticksToElapsedTime(this.lastWork + (long)size - System.currentTimeMillis(), true, true, false));
            return;
        }
        this.lastWork = System.currentTimeMillis();
        if (this.type == 3) {
            this.lastWork = System.currentTimeMillis() - (long)size;
            Server.sendData(player, EnumPacketClient.GET_SCHEMATIC, new Object[0]);
        } else if (this.type == 4) {
            this.saveBlocks(player, pos, size);
        } else {
            this.setBlocks((EntityPlayer)player, pos);
        }
    }

    public int getID() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }
}

